*! version 5.0
* 13 August 2018
* NIDS 
* This do-file contains the code to create deflators to deflate NIDS Wave 5 
* financial data. Deflated values can be generated by multiplying the relevant 
* financial data variable by the deflator generated by this do-file.

*=====================================================================================================================================
/*
* NOTE TO USERS

THIS DO FILE CREATES DEFLATORS FOR USE WITH THE MERGED WAVE 1, 2, 3, 4 AND 5 DATASETS. BASE MONTH IS MARCH 2017 (WAVE 5 MODAL MONTH) AND 
INTERVIEW DATES ARE TAKEN FROM THE HOUSEHOLD QUESTIONNAIRE. MISSING INTERVIEW MONTHS ARE IMPUTED TO THE MODAL MONTH FOR THE RELEVANT WAVE.

PRICE INDICES ARE FROM THE NATIONAL HEADLINE CPI INDEX PUBLISHED BY STATS SA, AVAILABLE HERE:
http://www.statssa.gov.za/publications/P0141/CPIHistory.pdf?
(Last accessed 11/05/2018).

CPI Headline Index (Dec 2012 = 100)
            2008	2010	2011	2012	2014	2015    2017*	
January		74.8	86.4	89.6	95.2	106.1	110.8	125.4 	
February	75.1	87.0	90.2	95.7	107.3	111.5	126.8	
March		76.3	87.7	91.3	96.8	108.7	113.1	127.6	
April		77.7	87.8	91.6	97.2	109.2	114.1	127.7
May         78.5	88.0	92.0	97.2	109.4	114.4	128.1
June		79.6	88.0	92.4	97.5	109.7	114.9	128.3
July		81.2	88.6	93.2	97.8	110.6	116.1	128.7
August		81.8	88.6	93.4	98.0	111.0	116.1	128.8	
September	81.9	88.7	93.8	98.9	111.0	116.1	129.4
October		81.9	88.9	94.2	99.5	111.2	116.4	129.8
November	82.0	89.0	94.5	99.8	111.2	116.5	129.9	
December	81.1	89.2	94.6	100		111.0	116.8	130.6
															
*The 2017 values have been calculated for the convenience of panel analysis.
Using the table below, with the new Stats SA CPI Headline Index baseline month as 
Dec 2016, the values for 2017 have been back-dated according to the old Stats SA 
CPI Headline Index baseline month of Dec 2012 shown above.
(The CPI value for Dec 2016 is 124.7 when using Dec 2012 = 100 as the base month.)

CPI Headline Index (Dec 2016 = 100)
            2016    2017	
January		94.4	100.6	
February	95.7	101.7	
March		96.4	102.3	
April		97.2	102.4
May         97.4	102.7
June		97.9	102.9
July		98.7	103.2
August		98.6	103.3	
September	98.8	103.8
October		99.3	104.1
November	99.6	104.2	
December	100		104.7

*/

*=====================================================================================================================================

* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

global W5Data "C:\Users\Admin\Desktop\W5"	//File path to where input data is located. Change this path according to where your data folder is located on your computer.
global W5VerIN "W5_Anon_V1.0.0"

global DataOUT "C:\Users\Admin\Desktop\W5"	//File path to where you want to save subsequent data files. 
global VersionOUT "merged"

global temp "C:\Users\Admin\Desktop\W5"		//Tempfile to hold all the working datasets, all working datasets will
											//be deleted from this folder at the completion of the do file execution.
																		
version 12.0								//Version of Stata being used, this is needed for the rename command.

clear
cap clear matrix
set more off

scalar base=127.7 							//Set scalar to base month, currently March 2017

*=====================================================================================================================================


* HOUSEHOLD QUESTIONNAIRE
use "$W5Data\HHQuestionnaire_$W5VerIN.dta", clear

*Wave 5
gen w5_deflator=.

replace w5_deflator=base/125.4 if w5_h_intrv_m==1 & w5_h_intrv_y==2017
replace w5_deflator=base/126.8 if w5_h_intrv_m==2 & w5_h_intrv_y==2017
replace w5_deflator=base/127.6 if w5_h_intrv_m==3 & w5_h_intrv_y==2017
replace w5_deflator=base/127.7 if w5_h_intrv_m==4 & w5_h_intrv_y==2017
replace w5_deflator=base/128.1 if w5_h_intrv_m==5 & w5_h_intrv_y==2017
replace w5_deflator=base/128.3 if w5_h_intrv_m==6 & w5_h_intrv_y==2017
replace w5_deflator=base/128.7 if w5_h_intrv_m==7 & w5_h_intrv_y==2017
replace w5_deflator=base/128.8 if w5_h_intrv_m==8 & w5_h_intrv_y==2017
replace w5_deflator=base/129.4 if w5_h_intrv_m==9 & w5_h_intrv_y==2017
replace w5_deflator=base/129.8 if w5_h_intrv_m==10 & w5_h_intrv_y==2017
replace w5_deflator=base/129.9 if w5_h_intrv_m==11 & w5_h_intrv_y==2017
replace w5_deflator=base/130.6 if w5_h_intrv_m==12 & w5_h_intrv_y==2017

replace w5_deflator=base/127.7 if w5_h_intrv_m==. & w5_h_outcome==1

lab var w5_deflator "Wave 5 deflator"

keep w5_hhid w5_deflator

merge 1:1 w5_hhid using "$W5Data\hhderived_$W5VerIN.dta"
drop _merge

save "$DataOUT\deflated_W5_$VersionOUT.dta", replace

*=====================================================================================================================================

* end of do file





















